(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15711,        388]
NotebookOptionsPosition[     15324,        374]
NotebookOutlinePosition[     15660,        389]
CellTagsIndexPosition[     15617,        386]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"files", "=", 
    RowBox[{"FileNames", "[", "\"\<./pars*\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Generate", " ", "population", " ", "average", " ", "of", " ", "speed"}], 
    ",", " ", 
    RowBox[{"aspect", " ", "ratio", " ", "and", " ", "persistence"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"finalresult", "=", 
    RowBox[{"First", "@", 
     RowBox[{"Last", "@", 
      RowBox[{"Reap", "@", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tardirs", "=", 
           RowBox[{"FileNames", "@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"FileBaseName", "@", "file"}], "<>", "\"\</rng*\>\""}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"msd", "=", 
           RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"result", "=", "\[IndentingNewLine]", 
           RowBox[{"Mean", "@", 
            RowBox[{"First", "@", 
             RowBox[{"Last", "@", 
              RowBox[{"Reap", "@", 
               RowBox[{"Do", "[", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Sow", "@", 
                   RowBox[{"Flatten", "@", 
                    RowBox[{"First", "@", 
                    RowBox[{"Last", "@", 
                    RowBox[{"Reap", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"config", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{"tardir", "<>", "\"\</config.json\>\""}], "]"}]}],
                     ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<STIFFNESS_MEMBRANE\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<SUBSTRATE_DISSIPATION\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/Speed\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/AspectRatio\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";"}], 
                    "\[IndentingNewLine]", "]"}]}]}]}]}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"msd", "=", 
                   RowBox[{"Join", "[", 
                    RowBox[{"msd", ",", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Simple/MSD\>\""}], "]"}]}], "]"}]}], ";"}], 
                 "\[IndentingNewLine]", ",", 
                 RowBox[{"{", 
                  RowBox[{"tardir", ",", "tardirs"}], "}"}]}], 
                "]"}]}]}]}]}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"grpmsd", "=", 
           RowBox[{"GroupBy", "[", 
            RowBox[{"msd", ",", "First"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"meanmsd", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"\"\<DeltaTime\>\"", "/.", "val"}], "//", "Mean"}], 
               ",", 
               RowBox[{
                RowBox[{"\"\<Value\>\"", "/.", "val"}], "//", "Mean"}], ",", 
               RowBox[{
                RowBox[{"\"\<Value\>\"", "/.", "val"}], "//", 
                "StandardDeviation"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"val", ",", "grpmsd"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Fit", " ", "persistent", " ", "random", " ", "walk", " ", 
            "model"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"msdfit", "=", 
           RowBox[{"NonlinearModelFit", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"meanmsd", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"2", ";;", 
                 RowBox[{"-", "1"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], 
             "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"A", "^", "2"}], "*", 
                RowBox[{"tau", "^", "2"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", "t"}], "/", "tau"}], "]"}], "+", 
                  RowBox[{"t", "/", "tau"}], "-", "1"}], ")"}]}], ",", 
               RowBox[{"tau", ">", "0.0001"}], ",", 
               RowBox[{"A", ">", "0"}]}], "}"}], "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"A", ",", "10"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"tau", ",", "10000"}], "}"}]}], "}"}], 
             "\[IndentingNewLine]", ",", "t", ",", 
             RowBox[{"Weights", "\[Rule]", 
              RowBox[{"1", "/", 
               RowBox[{
                RowBox[{"meanmsd", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"2", ";;", 
                    RowBox[{"-", "1"}]}], ",", "3"}], "]"}], "]"}], "^", 
                "2"}]}]}], ",", 
             RowBox[{"Method", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"NMinimize", ",", 
                RowBox[{"Method", "\[Rule]", "\"\<NelderMead\>\""}]}], 
               "}"}]}], ",", 
             RowBox[{"ConfidenceLevel", "\[Rule]", "0.999"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"result", ",", 
            RowBox[{"tau", "/.", 
             RowBox[{"msdfit", "[", "\"\<BestFitParameters\>\"", "]"}]}]}], 
           "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"Sow", "@", "result"}], ";"}], "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"file", ",", "files"}], "}"}]}], "]"}]}]}]}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Round", " ", "membrane", " ", "stiffness"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"finalresult", "[", 
       RowBox[{"[", 
        RowBox[{"k", ",", "1"}], "]"}], "]"}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{"Round", "[", 
         RowBox[{"1000", "*", 
          RowBox[{"finalresult", "[", 
           RowBox[{"[", 
            RowBox[{"k", ",", "1"}], "]"}], "]"}]}], "]"}], "/", "1000"}], "//",
        "N"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"Length", "@", "finalresult"}]}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Group", " ", "data", " ", "by", " ", "membrane", " ", "stiffness"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "membrane", " ", "stiffness"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "substrate", " ", "dissipation"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "speed"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "aspect", " ", "ratio"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#5", " ", "persistence"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalresult", "=", 
   RowBox[{"SortBy", "[", 
    RowBox[{"finalresult", ",", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0054", "=", 
   RowBox[{"0.054", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0054", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.054"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0057", "=", 
   RowBox[{"0.057", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0057", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.057"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0060", "=", 
   RowBox[{"0.060", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0060", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.060"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0063", "=", 
   RowBox[{"0.063", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0063", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.063"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result0066", "=", 
   RowBox[{"0.066", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result0066", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.066"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.740473733603188*^9, 3.7404737427275352`*^9}, {
   3.7404743487962112`*^9, 3.7404744048960133`*^9}, {3.740474553138999*^9, 
   3.740474576977846*^9}, {3.7404746317376842`*^9, 3.7404747301614637`*^9}, 
   3.7404747631252127`*^9, {3.740474799734309*^9, 3.74047480082445*^9}, {
   3.740475644270343*^9, 3.7404756860640287`*^9}, {3.740475807551002*^9, 
   3.7404759497260637`*^9}, {3.7404782973335257`*^9, 3.740478417250231*^9}, {
   3.7404784807142057`*^9, 3.7404784812280416`*^9}, {3.740562039096106*^9, 
   3.740562116814569*^9}, {3.740562223374802*^9, 3.740562234714262*^9}, {
   3.740562362929048*^9, 3.7405623843951073`*^9}, {3.740562420435128*^9, 
   3.740562658752768*^9}, 3.740563059159471*^9, {3.740563165138597*^9, 
   3.740563168861841*^9}, {3.740563243686219*^9, 3.740563246699719*^9}, {
   3.7405635603605328`*^9, 3.7405636014813633`*^9}, {3.740572893734722*^9, 
   3.74057289796838*^9}, 3.740573734870708*^9, {3.7406397600526047`*^9, 
   3.740639779423215*^9}, {3.740639996821848*^9, 3.740640057971066*^9}, {
   3.740640103630518*^9, 3.7406401046933813`*^9}, {3.740640148469658*^9, 
   3.74064016450458*^9}, {3.7406402223577623`*^9, 3.740640229789052*^9}, {
   3.740640468942174*^9, 3.740640491188933*^9}, 3.7407191473255672`*^9, {
   3.740719183834629*^9, 3.740719184076961*^9}, {3.7407194346455793`*^9, 
   3.7407194535781307`*^9}, {3.740725792331171*^9, 3.7407257958827457`*^9}, {
   3.740725829635138*^9, 3.740725857059944*^9}, {3.740726097172914*^9, 
   3.7407261001087503`*^9}, {3.74072711031215*^9, 3.740727117945513*^9}, {
   3.740727471560315*^9, 3.740727482062001*^9}, {3.7407312439849977`*^9, 
   3.74073125063311*^9}, {3.740731286377161*^9, 3.7407314900148573`*^9}, {
   3.740731742662314*^9, 3.740731747838747*^9}, {3.7407318166911917`*^9, 
   3.7407318175868473`*^9}, {3.740731889782754*^9, 3.7407318966421432`*^9}, {
   3.7407321268142967`*^9, 3.7407321328602667`*^9}, {3.740732258343833*^9, 
   3.7407322689325943`*^9}, {3.74073235640373*^9, 3.740732387789772*^9}, {
   3.740732444405113*^9, 3.7407324458294277`*^9}, {3.740736365662232*^9, 
   3.74073638087253*^9}, {3.741515947265167*^9, 3.7415159654773207`*^9}, {
   3.741516279061537*^9, 3.741516279204852*^9}, 3.742232364187449*^9, {
   3.742232647174975*^9, 3.742232654312055*^9}, 3.7422327322232103`*^9, {
   3.742232773664627*^9, 3.742232781296053*^9}, {3.742232830159417*^9, 
   3.742232846714345*^9}, 3.7422374827821093`*^9, {3.742268208707362*^9, 
   3.7422682222913857`*^9}, {3.742268260499058*^9, 3.742268263552306*^9}, {
   3.7765101906867323`*^9, 3.776510289106859*^9}, {3.7765103225292187`*^9, 
   3.7765103237578087`*^9}, {3.7765105775503693`*^9, 
   3.7765106013946447`*^9}, {3.776510651784347*^9, 3.776510662528666*^9}, {
   3.7765353957170143`*^9, 
   3.776535396130427*^9}},ExpressionUUID->"4a0e8568-03be-46e1-bbc4-\
f4aa69d21521"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/thueroffpaper_single_Dm.dat\>\"", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
     "result0054", ",", "result0057", ",", "result0060", ",", "result0063", 
      ",", "result0066"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.77652028111285*^9, 
  3.776520281884021*^9}},ExpressionUUID->"9a3cacb4-5014-4445-9460-\
388e2e82de80"]
},
WindowSize->{808, 755},
WindowMargins->{{Automatic, 69}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 14250, 338, 1270, "Input",ExpressionUUID->"4a0e8568-03be-46e1-bbc4-f4aa69d21521"],
Cell[14811, 360, 509, 12, 73, "Input",ExpressionUUID->"9a3cacb4-5014-4445-9460-388e2e82de80"]
}
]
*)

